using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp155
{
    internal class Program
    {
        class VanOgranicenja : ArgumentException
        {
            public VanOgranicenja(string poruka) : base(poruka) { }
        }
        static void Main(string[] args)
        {
            try
            {
                int n = int.Parse(Console.ReadLine());
                if((n<2) || (n>200000))
                {
                    throw new VanOgranicenja("Unos je van ogranicenja (2 <= n >= 200000).");
                }
                List<long[]> Tacke = new List<long[]>();
                for (int i = 0; i < n; i++)
                {
                    long[] t = Array.ConvertAll(Console.ReadLine().Split(), long.Parse);
                    Tacke.Add(t);
                    if ((Tacke[i][0] < -1000000000) || (Tacke[i][0] > 1000000000))
                    {
                        throw new VanOgranicenja("Unos je van ogranicenja (-1000000000 <= x >= 1000000000).");
                    }
                    else if((Tacke[i][1] < -1000000000) || (Tacke[i][1] > 1000000000))
                    {
                        throw new VanOgranicenja("Unos je van ogranicenja (-1000000000 <= y >= 1000000000).");
                    }
                }

                int br = 0;
                for (int i = 0; i < n; i++)
                {
                    for (int j = i + 1; j < n; j++)
                    {
                        if((Tacke[i][0] == Tacke[j][0]) && (Tacke[i][1] == Tacke[j][1]))
                        {
                            throw new VanOgranicenja("Sve tacke se moraju medusobno razlikovati.");
                        }
                        if ((Tacke[i][0] == Tacke[j][0]) || (Tacke[i][1] == Tacke[j][1]))
                        {
                            br++;
                        }
                        else if (Tacke[i][0] - Tacke[j][0] == Tacke[i][1] - Tacke[j][1])
                        {
                            br += 2;
                        }
                    }
                }
                Console.WriteLine(br);
            }
            catch(ArgumentException ae)
            {
                Console.Write("Detalji greške: " + ae.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine("Desila se neocekivana greška.");
                Console.Write("Detalji greške: " + e.Message);
            }
        }
    }
}